// Copyright (c) Microsoft Corporation. All rights reserved.
"use strict";
var http = require("http");
var shared = require("./shared-types");
var Server = (function () {
function Server(pipeNameSuffix) {
this.pipeName = "vs.node." + pipeNameSuffix;
}
Server.prototype.Start = function (callback) {
this.server = http.createServer(Server.RequestHandler);
this.server.setTimeout(0);
var pipeName = this.pipeName;
var listener = this.server.listen("\\\\.\\pipe\\" + this.pipeName, function () {
if (callback)
callback(pipeName);
});
listener
.on('clientError', function (exception) {
console.log(pipeName + ' Client error:\n' + exception);
})
.on('close', function () {
console.log(pipeName + ' closed.');
});
};
Server.RequestHandler = function (request, response) {
var context = new shared.HttpContext(request, response);
if (request.method !== "POST") {
context.RespondMethodNotSupported();
return;
}
if (!Server.ProcessRequest(context)) {
context.RespondNotFound();
return;
}
};
Server.ProcessRequest = function (context) {
var parts = context.RequestUrl.substring(1).split('/');
if (parts.length < 2) {
return false;
}
var commandModule = Server.GetCommandModule(parts[0]);
if (!commandModule) {
return false;
}
var commandName = parts[1];
var commandArgs = parts.slice(2);
if (!commandModule[commandName]) {
return false;
}
if (!commandModule[commandName](context, commandArgs)) {
return false;
}
return true;
};
Server.GetCommandModule = function (moduleName) {
switch (moduleName) {
case "bower":
return require("./bower-commands");
case "lint":
return require("./lint-commands");
case "npm":
return require("./npm-commands");
case "utility":
return require("./utility-commands");
default:
return null;
}
};
return Server;
}());
exports.Server = Server;

// SIG // Begin signature block
// SIG // MIIdswYJKoZIhvcNAQcCoIIdpDCCHaACAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFGP1d+FWe4vy
// SIG // nkqz5Zwb/jJJNtpuoIIYZTCCBMMwggOroAMCAQICEzMA
// SIG // AADL2VIGU78+KlkAAAAAAMswDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE2MDkwNzE3
// SIG // NTg1NVoXDTE4MDkwNzE3NTg1NVowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjo1ODQ3LUY3NjEtNEY3MDEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBALptTyOs/FJOzo4foxwO6pD7ahpfoPTpdKimAT7R
// SIG // sWe0oCLma13H0lYn1I4F8JPtKvU0BUog/v2+S2pKGhOz
// SIG // p8L4eRioxa2R+GJrvJcJiEARQmuZYnj0U51UMmwP3NfE
// SIG // v/AIYV5+7d/0C4Idu7z+xZxct5Q2IlaBIcTONJL+rzND
// SIG // rogZRU8cFnwVs8Bw3ptHAMPfSILROFH2nH7X5piFTGs0
// SIG // U5V9TNUi2Ex6NLucmjolNWnNYtqvyt9D3sBvvfe0CR5K
// SIG // QurpgPV8B6+HphV94agAoQDv3x63d20TNDjDR9rABWE8
// SIG // +NYx9A+6I8nkYkYDIvsAFLS9bvlk2t0UNzThe1UCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBSYx5xZ88DA2NKqKnL9
// SIG // 3X1y9jw/5jAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQBLIAVUQ9Jr
// SIG // GMrIdLhBTcLN3Qz+a4qqVbGphiaVgjJSRjZePi1+CSL9
// SIG // vNzE7AlN+y2jSGxo4U7kouIn1cr7O98bInK+LT4hiuyG
// SIG // AUbYSi/97RI3jP5hlkn2Nq2UYEsFCmzyBlc9SIB2jptP
// SIG // PbG+kOsguBJBDgMU64QUv+EmXkzNkbk9KPKxbX31keLF
// SIG // vEq6YL0ULs9vFgLtsA2d1007wJohfnI7pq8enwPFGi4W
// SIG // Bui1ryWU+s65bGfA3E2TMGS58OrSkoqr2+oLyHMg03FY
// SIG // 9uRkbpd8sy34LJi1hk0Te8KAkhs33YMpKgZ3WKODkuhN
// SIG // LLMYz0fMycNA24SY71DLSf3oMIIGBzCCA++gAwIBAgIK
// SIG // YRZoNAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYK
// SIG // CZImiZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJ
// SIG // bWljcm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9v
// SIG // dCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAz
// SIG // MTI1MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IB
// SIG // DwAwggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQ
// SIG // rc7dGE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm
// SIG // 2gBr6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd
// SIG // 6udOo6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOw
// SIG // htDlKEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7Po
// SIG // IZd++NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi
// SIG // +YSnEUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1U
// SIG // n68eeEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXD
// SIG // wiALAgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/
// SIG // MB0GA1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzAL
// SIG // BgNVHQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgG
// SIG // A1UdIwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KSh
// SIG // Y6RhMF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJ
// SIG // kiaJk/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1p
// SIG // Y3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0
// SIG // eYIQea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWg
// SIG // Q6BBhj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5j
// SIG // cmwwVAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjho
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRz
// SIG // L01pY3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeK
// SIG // w1wDRDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQS
// SIG // ooxtYrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ
// SIG // 7DsB7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+F
// SIG // A+mRKiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxn
// SIG // LcVRDupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+F
// SIG // ChPfwgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4w
// SIG // yrt4ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1w
// SIG // lGysOUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8cs
// SIG // u89Ds+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyz
// SIG // s7BNZ8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RI
// SIG // zCzU2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/
// SIG // m4LBJ1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HI
// SIG // jCPJZr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCs
// SIG // lLCleKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbr
// SIG // Hk/Jmu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0b
// SIG // odj6L54/LlUWa8kTo/0wggYRMIID+aADAgECAhMzAAAA
// SIG // joeRpFcaX8o+AAAAAACOMA0GCSqGSIb3DQEBCwUAMH4x
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jv
// SIG // c29mdCBDb2RlIFNpZ25pbmcgUENBIDIwMTEwHhcNMTYx
// SIG // MTE3MjIwOTIxWhcNMTgwMjE3MjIwOTIxWjCBgzELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEeMBwG
// SIG // A1UEAxMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0IfUQit+
// SIG // ndnGetSiw+MVktJTnZUXyVI2+lS/qxCv6cnnzCZTw8Jz
// SIG // v23WAOUA3OlqZzQw9hYXtAGllXyLuaQs5os7efYjDHmP
// SIG // 81LfQAEcwsYDnetZz3Pp2HE5m/DOJVkt0slbCu9+1jIO
// SIG // XXQSBOyeBFOmawJn+E1Zi3fgKyHg78CkRRLPA3sDxjnD
// SIG // 1CLcVVx3Qv+csuVVZ2i6LXZqf2ZTR9VHCsw43o17lxl9
// SIG // gtAm+KWO5aHwXmQQ5PnrJ8by4AjQDfJnwNjyL/uJ2hX5
// SIG // rg8+AJcH0Qs+cNR3q3J4QZgHuBfMorFf7L3zUGej15Tw
// SIG // 0otVj1OmlZPmsmbPyTdo5GPHzwIDAQABo4IBgDCCAXww
// SIG // HwYDVR0lBBgwFgYKKwYBBAGCN0wIAQYIKwYBBQUHAwMw
// SIG // HQYDVR0OBBYEFKvI1u2yFdKqjvHM7Ww490VK0Iq7MFIG
// SIG // A1UdEQRLMEmkRzBFMQ0wCwYDVQQLEwRNT1BSMTQwMgYD
// SIG // VQQFEysyMzAwMTIrYjA1MGM2ZTctNzY0MS00NDFmLWJj
// SIG // NGEtNDM0ODFlNDE1ZDA4MB8GA1UdIwQYMBaAFEhuZOVQ
// SIG // BdOCqhc3NyK1bajKdQKVMFQGA1UdHwRNMEswSaBHoEWG
// SIG // Q2h0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMv
// SIG // Y3JsL01pY0NvZFNpZ1BDQTIwMTFfMjAxMS0wNy0wOC5j
// SIG // cmwwYQYIKwYBBQUHAQEEVTBTMFEGCCsGAQUFBzAChkVo
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2Nl
// SIG // cnRzL01pY0NvZFNpZ1BDQTIwMTFfMjAxMS0wNy0wOC5j
// SIG // cnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsFAAOC
// SIG // AgEARIkCrGlT88S2u9SMYFPnymyoSWlmvqWaQZk62J3S
// SIG // VwJRavq/m5bbpiZ9CVbo3O0ldXqlR1KoHksWU/PuD5rD
// SIG // BJUpwYKEpFYx/KCKkZW1v1rOqQEfZEah5srx13R7v5II
// SIG // UV58MwJeUTub5dguXwJMCZwaQ9px7eTZ56LadCwXreUM
// SIG // tRj1VAnUvhxzzSB7pPrI29jbOq76kMWjvZVlrkYtVylY
// SIG // 1pLwbNpj8Y8zon44dl7d8zXtrJo7YoHQThl8SHywC484
// SIG // zC281TllqZXBA+KSybmr0lcKqtxSCy5WJ6PimJdXjryp
// SIG // WW4kko6C4glzgtk1g8yff9EEjoi44pqDWLDUmuYx+pRH
// SIG // jn2m4k5589jTajMWUHDxQruYCen/zJVVWwi/klKoCMTx
// SIG // 6PH/QNf5mjad/bqQhdJVPlCtRh/vJQy4njpIBGPveJii
// SIG // XQMNAtjcIKvmVrXe7xZmw9dVgh5PgnjJnlQaEGC3F6tA
// SIG // E5GusBnBmjOd7jJyzWXMT0aYLQ9RYB58+/7b6Ad5B/eh
// SIG // Mzj+CZrbj3u2Or2FhrjMvH0BMLd7HaldG73MTRf3bkcz
// SIG // 1UDfasouUbi1uc/DBNM75ePpEIzrp7repC4zaikvFErq
// SIG // HsEiODUFhe/CBAANa8HYlhRIFa9+UrC4YMRStUqCt4Uq
// SIG // AEkqJoMnWkHevdVmSbwLnHhwCbwwggd6MIIFYqADAgEC
// SIG // AgphDpDSAAAAAAADMA0GCSqGSIb3DQEBCwUAMIGIMQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNyb3Nv
// SIG // ZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAx
// SIG // MTAeFw0xMTA3MDgyMDU5MDlaFw0yNjA3MDgyMTA5MDla
// SIG // MH4xCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01p
// SIG // Y3Jvc29mdCBDb2RlIFNpZ25pbmcgUENBIDIwMTEwggIi
// SIG // MA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCr8Ppy
// SIG // EBwurdhuqoIQTTS68rZYIZ9CGypr6VpQqrgGOBoESbp/
// SIG // wwwe3TdrxhLYC/A4wpkGsMg51QEUMULTiQ15ZId+lGAk
// SIG // bK+eSZzpaF7S35tTsgosw6/ZqSuuegmv15ZZymAaBelm
// SIG // dugyUiYSL+erCFDPs0S3XdjELgN1q2jzy23zOlyhFvRG
// SIG // uuA4ZKxuZDV4pqBjDy3TQJP4494HDdVceaVJKecNvqAT
// SIG // d76UPe/74ytaEB9NViiienLgEjq3SV7Y7e1DkYPZe7J7
// SIG // hhvZPrGMXeiJT4Qa8qEvWeSQOy2uM1jFtz7+MtOzAz2x
// SIG // sq+SOH7SnYAs9U5WkSE1JcM5bmR/U7qcD60ZI4TL9LoD
// SIG // ho33X/DQUr+MlIe8wCF0JV8YKLbMJyg4JZg5SjbPfLGS
// SIG // rhwjp6lm7GEfauEoSZ1fiOIlXdMhSz5SxLVXPyQD8NF6
// SIG // Wy/VI+NwXQ9RRnez+ADhvKwCgl/bwBWzvRvUVUvnOaEP
// SIG // 6SNJvBi4RHxF5MHDcnrgcuck379GmcXvwhxX24ON7E1J
// SIG // MKerjt/sW5+v/N2wZuLBl4F77dbtS+dJKacTKKanfWeA
// SIG // 5opieF+yL4TXV5xcv3coKPHtbcMojyyPQDdPweGFRInE
// SIG // CUzF1KVDL3SV9274eCBYLBNdYJWaPk8zhNqwiBfenk70
// SIG // lrC8RqBsmNLg1oiMCwIDAQABo4IB7TCCAekwEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFEhuZOVQBdOCqhc3
// SIG // NyK1bajKdQKVMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFHItOgIxkEO5FAVO4eqnxzHRI4k0
// SIG // MFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dDIwMTFfMjAxMV8wM18yMi5jcmwwXgYIKwYB
// SIG // BQUHAQEEUjBQME4GCCsGAQUFBzAChkJodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY1Jvb0Nl
// SIG // ckF1dDIwMTFfMjAxMV8wM18yMi5jcnQwgZ8GA1UdIASB
// SIG // lzCBlDCBkQYJKwYBBAGCNy4DMIGDMD8GCCsGAQUFBwIB
// SIG // FjNodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3Bz
// SIG // L2RvY3MvcHJpbWFyeWNwcy5odG0wQAYIKwYBBQUHAgIw
// SIG // NB4yIB0ATABlAGcAYQBsAF8AcABvAGwAaQBjAHkAXwBz
// SIG // AHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcNAQEL
// SIG // BQADggIBAGfyhqWY4FR5Gi7T2HRnIpsLlhHhY5KZQpZ9
// SIG // 0nkMkMFlXy4sPvjDctFtg/6+P+gKyju/R6mj82nbY78i
// SIG // NaWXXWWEkH2LRlBV2AySfNIaSxzzPEKLUtCw/WvjPgcu
// SIG // KZvmPRul1LUdd5Q54ulkyUQ9eHoj8xN9ppB0g430yyYC
// SIG // RirCihC7pKkFDJvtaPpoLpWgKj8qa1hJYx8JaW5amJbk
// SIG // g/TAj/NGK978O9C9Ne9uJa7lryft0N3zDq+ZKJeYTQ49
// SIG // C/IIidYfwzIY4vDFLc5bnrRJOQrGCsLGra7lstnbFYhR
// SIG // RVg4MnEnGn+x9Cf43iw6IGmYslmJaG5vp7d0w0AFBqYB
// SIG // Kig+gj8TTWYLwLNN9eGPfxxvFX1Fp3blQCplo8NdUmKG
// SIG // wx1jNpeG39rz+PIWoZon4c2ll9DuXWNB41sHnIc+BncG
// SIG // 0QaxdR8UvmFhtfDcxhsEvt9Bxw4o7t5lL+yX9qFcltgA
// SIG // 1qFGvVnzl6UJS0gQmYAf0AApxbGbpT9Fdx41xtKiop96
// SIG // eiL6SJUfq/tHI4D1nvi/a7dLl+LrdXga7Oo3mXkYS//W
// SIG // syNodeav+vyL6wuA6mk7r/ww7QRMjt/fdW1jkT3RnVZO
// SIG // T7+AVyKheBEyIXrvQQqxP/uozKRdwaGIm1dxVk5IRcBC
// SIG // yZt2WwqASGv9eZ/BvW1taslScxMNelDNMYIEujCCBLYC
// SIG // AQEwgZUwfjELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEoMCYGA1UE
// SIG // AxMfTWljcm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EgMjAx
// SIG // MQITMwAAAI6HkaRXGl/KPgAAAAAAjjAJBgUrDgMCGgUA
// SIG // oIHOMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
// SIG // CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
// SIG // SIb3DQEJBDEWBBTOMeW+iee1hU0CZssjL9muYKNbCTBu
// SIG // BgorBgEEAYI3AgEMMWAwXqBEgEIATQBpAGMAcgBvAHMA
// SIG // bwBmAHQAIABWAGkAcwB1AGEAbAAgAFMAdAB1AGQAaQBv
// SIG // ACAAVwBlAGIAIABUAG8AbwBsAHOhFoAUaHR0cDovL3d3
// SIG // dy5hc3AubmV0LyAwDQYJKoZIhvcNAQEBBQAEggEABmKF
// SIG // kPvM8DImKNiGe6+jal6+F2ZOrrAb3RBeHYlctjVifgWX
// SIG // 4WoizxlC8XCfP6ugdZvxXLGtbSamW0+dZC0S3u8ri3/N
// SIG // 9upzQ/VZgTOwDmB4PAv1rMmhma7d9gSUBb8f7U/1YPB8
// SIG // jcOt8Wqp5UblPJQLylb6YSOSf9FOwVxP7P/VcJZM2MY5
// SIG // rCNzkdft5qzOaBmPbj7AEXLdq2IWGyq4lHrQZVQAV7O1
// SIG // OjoNDqETylUOlzuiExK8ZCJ7s1nWyjoYpgzITuNzTjIA
// SIG // 5SehwbzJ3EEiLsF/GHK9SXOSrhmb2Lt5vtmGBqKAX7vW
// SIG // sD4F13lFTvMJAfKQQK+sDZJh1TC78aGCAigwggIkBgkq
// SIG // hkiG9w0BCQYxggIVMIICEQIBATCBjjB3MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0ECEzMAAADL2VIGU78+KlkAAAAAAMsw
// SIG // CQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG
// SIG // 9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTE3MDIyNDA2MTkx
// SIG // OVowIwYJKoZIhvcNAQkEMRYEFCrYyY5gJRmUtTe0VV0I
// SIG // rKn2fBYuMA0GCSqGSIb3DQEBBQUABIIBAGBOhH+8KdLr
// SIG // zeuP0Pe379N602cUH8CNLARIi4Ua/Pz8P2uZvs933rVd
// SIG // DPmaJgwU02reejcc5+7CKdESMlSaJKKySkloAN8suewh
// SIG // WxVkCIDyxRe4g0Zb7ooCJhgxEYvJGkw/brKRH/1RHJQt
// SIG // UmBFnjTEBs76P7oC9E5Z4KTaipyyg1kadZ1NqfQjLbk2
// SIG // Yk36UZBFyN/BXbPS21pjmKwLtVlEwbd7aaH9Z0TigEE3
// SIG // SQDZj9fA8WwU0T+Qi2E7Sm5cCRMSk/SUkguUwZaqOeQ1
// SIG // T8watds58cVheOlQB7VmXK7R9/x4EqnISCmriXOuYhDd
// SIG // xdec+/cbLfz87QU9xau2CFA=
// SIG // End signature block
